const White = 0xFFFFFFFF;

// Function hooking example that adds all created vehicles to
// an array then deletes them when the script unloads
local vehicles = {};
local createVehicle_Original = createVehicle;
local blip1, blip2;

function createVehicle(model, x, y, z, r, c1, c2, c3, c4)
{
	local vehicleId = createVehicle_Original(model, x, y, z, r, c1, c2, c3, c4);

	if(vehicleId != INVALID_VEHICLE_ID)
	{
		log("Created a vehicle with id " + vehicleId + " (Model " + model + " (" + getVehicleName(model) + "))");
		vehicles[vehicles.len()] <- vehicleId;
	}


	return vehicleId;
}

function onScriptInit()
{
	createVehicle(65, -343.447662, 1176.119263, 14.146016, 268.219513, 0, 0, 0, 0); // Police Patriot
	createVehicle(90, -343.527313, 1172.740479, 14.199832, 268.217010, 0, 0, 0, 0); // Sultan RS 2
	createVehicle(90, -343.501099, 1168.932739, 14.199870, 269.241302, 0, 0, 0, 0); // Sultan RS 3
	createVehicle(90, -343.609344, 1166.145630, 14.199894, 268.305298, 0, 0, 0, 0); // Sultan RS 4
	createVehicle(90, -343.623444, 1162.919067, 14.199799, 269.975037, 0, 0, 0, 0); // Sultan RS 5
	createVehicle(90, -343.633057, 1158.563843, 14.126013, 270.858826, 0, 0, 0, 0); // Sultan RS 6
	
	sendConsoleInput("uptime");
	log(format("Hello %s 0x%x %d", "World", 1337, 1337));
	log(_version_);
	local config = getConfig();
	log("Port = " + config["port"]);
	log("---------------------");
	log(SCRIPT_NAME + " loaded");
	log("---------------------");
	
	return 1;
}
addEvent("scriptInit", onScriptInit);

function onScriptExit()
{	
	for(local i = 0; i < vehicles.len(); i++)
		deleteVehicle(vehicles[i]);

	return 1;
}
addEvent("scriptExit", onScriptExit);

function onPlayerConnect(playerid)
{
	sendMessageToAll(getPlayerName(playerid) + " (" + playerid + ") has joined the server.", White);
	sendPlayerMessage(playerid, "Welcome to Central Park", White);
	setPlayerSpawnLocation(playerid, -341.36, 1144.80, 14.79, 40.114815);
	//displayPlayerText(playerid, 0.5, 0.5, "Central ~r~Park");
	return 1;
}
addEvent("playerConnect", onPlayerConnect);

function onPlayerDisconnect(playerid, reason)
{
	local strreason = "Quit";

	if(reason == 1)
		strreason = "Timeout/Crash";

	sendMessageToAll(getPlayerName(playerid) + " (" + playerid + ") has left the server (" + strreason + ").", White);
	return 1;
}
addEvent("playerDisconnect", onPlayerDisconnect);

function onPlayerCommand(playerid, command)
{
	local cmd = split(command, " ");
	
	if(cmd[0] == "/grav")
	{
		setPlayerGravity(playerid, 0);
		return 1;
	}
	
	if(cmd[0] == "/grav1")
	{
		setPlayerGravity(playerid, 1);
		return 1;
	}	
	
	if(cmd[0] == "/kill")
	{
		setPlayerHealth(playerid, -1);
		return 1;
	}
	
	if(cmd[0] == "/model")
	{
		if(cmd.len() == 2)
		{
			if(setPlayerModel(playerid, cmd[1].tointeger()))
				sendPlayerMessage(playerid, "Model set to " + cmd[1], White);
		}

		return 1;
	}
	
	if(cmd[0] == "/testtime")
	{
		setPlayerTime(playerid, 23, 0);
		return 1;
	}
	
	if(cmd[0] == "/testweapon")
	{
		givePlayerWeapon(playerid, 9, 20);
		return 1;
	}

	if(cmd[0] == "/time")
	{
		if(cmd.len() == 3)
			setPlayerTime(playerid, cmd[1].tointeger(), cmd[2].tointeger());

		return 1;
	}

	if(cmd[0] == "/wep")
	{
		if(cmd.len() == 3)
			givePlayerWeapon(playerid, cmd[1].tointeger(), cmd[2].tointeger());

		return 1;
	}

	if(cmd[0] == "/h" || cmd[0] == "/health")
	{
		if(cmd.len() == 2)
		{
			if(cmd[1].tofloat() >= 0 && cmd[1].tofloat() <= 200)
				setPlayerHealth(playerid, cmd[1].tointeger());
		}

		return 1;
	}

	if(cmd[0] == "/a" || cmd[0] == "/armour")
	{
		if(cmd.len() == 2)
		{
			if(cmd[1].tofloat() > 0 && cmd[1].tofloat() <= 200)
			{
				sendPlayerMessage(playerid, "Armour change to " + cmd[1]);
				setPlayerArmour(playerid, cmd[1].tointeger());
			}
		}

		return 1;
	}

	if(cmd[0] == "/autoaim")
	{
		if(cmd.len() == 2)
		{
			if(cmd[1] == "true") togglePlayerAutoAim(playerid, true);
			else togglePlayerAutoAim(playerid, false);
		}

		return 1;
	}

	if(cmd[0] == "/v")
	{
		if(cmd.len() == 2)
		{
			local model = cmd[1].tointeger();
			local pos;
			if(isPlayerInAnyVehicle(playerid))
				pos = getVehicleCoordinates(getPlayerVehicleId(playerid));
			else
				pos = getPlayerCoordinates(playerid);
			local heading = getPlayerHeading(playerid);
			local veh = createVehicle(model, pos[0], pos[1], pos[2], heading, 1, 1, 1, 1);
			if(veh != INVALID_VEHICLE_ID)
			{
				warpPlayerIntoVehicle(playerid, veh);
				sendPlayerMessage(playerid, getVehicleName(model) + " spawned at your position (ID " + veh + ").");
			}
		}

		return 1;
	}
	
	if(cmd[0] == "/out")
	{
		sendPlayerMessage(playerid, "You are being warped out of your vehicle.");
		removePlayerFromVehicle(playerid);
		return 1;
	}

	if(cmd[0] == "/testmessage")
	{
		sendPlayerMessage(playerid, "Hello [FF0000FF]World", White, true);
		return 1;
	}

	if(cmd[0] == "/testobject")
	{
		// http://www.gtamodding.com/index.php?title=Category:Static_Model_Hashes
		createObject(0xB4FC2C1B, -341.36, 1144.80, 14.79, 0, 0, 0);
		return 1;
	}

	if(cmd[0] == "/money")
	{
		if(cmd.len() == 2)
		{
			setPlayerMoney(playerid, cmd[1].tointeger());
			sendPlayerMessage(playerid, "Money set", White);
		}

		return 1;
	}
	
	if(cmd[0] == "/text")
	{
		if(cmd.len() == 3)
			displayPlayerText(playerid, 0.1, 0.1, cmd[1].tostring(), cmd[2].tointeger());

		return 1;
	}
	
		if(cmd[0] == "/infotext")
	{
		if(cmd.len() == 3)
			displayPlayerInfoText(playerid, cmd[1].tostring(), cmd[2].tointeger());

		return 1;
	}

	if(cmd[0] == "/texttoall")
	{
		if(cmd.len() == 3)
			displayTextToAll(0.1, 0.1, cmd[1].tostring(), cmd[2].tointeger());

		return 1;
	}

	if(cmd[0] == "/physics")
	{
		if(cmd.len() == 2)
			togglePlayerPhysics(playerid, cmd[1].tointeger());

		return 1;
	}

	if(cmd[0] == "/controls")
	{
		if(cmd.len() == 2)
			togglePlayerControls(playerid, cmd[1].tointeger());

		return 1;
	}

	if(cmd[0] == "/wanted")
	{
		if(cmd.len() == 2)
			setPlayerWantedLevel(playerid, cmd[1].tointeger());
		
		return 1;
	}

	if(cmd[0] == "/goto")
	{
		if(cmd.len() == 2)
		{
			local toPlayerId = cmd[1].tointeger();

			if(!isPlayerConnected(toPlayerId))
			{
				sendPlayerMessage(playerid, "That player is not connected.");
				return 1;
			}

			local pos;
			if(isPlayerInAnyVehicle(toPlayerId))
				pos = getVehicleCoordinates(getPlayerVehicleId(toPlayerId));
			else
				pos = getPlayerCoordinates(toPlayerId);

			if(isPlayerInAnyVehicle(playerid))
				setVehicleCoordinates(getPlayerVehicleId(playerid), pos[0], pos[1], pos[2]);
			else
				setPlayerCoordinates(playerid, pos[0], pos[1], pos[2]);
			
			sendPlayerMessage(playerid, "You have been teleported.");
		}

		return 1;
	}

	if(cmd[0] == "/testcheckpoint")
	{
		if(cmd.len() == 2)
		{
			for(local i = 0; i < 32; i++)
			{
				hideCheckpointForAll(i);
				deleteCheckpoint(i);
			}
			local pos;
			if(isPlayerInAnyVehicle(playerid))
				pos = getVehicleCoordinates(getPlayerVehicleId(playerid));
			else
				pos = getPlayerCoordinates(playerid);
			local checkpointid = createCheckpoint(cmd[1].tointeger(), pos[0], pos[1], pos[2], pos[0], pos[1], (pos[2] + 10), 5);
			showCheckpointForAll(checkpointid);
			sendPlayerMessage(playerid, "Checkpoint created with id " + checkpointid);
		}
	}

	if(cmd[0] == "/vh")
	{
		if(cmd.len() == 2)
		{
			if(isPlayerInAnyVehicle(playerid))
			{
				local vehicleid = getPlayerVehicleId(playerid);
				local oldhealth = getVehicleEngineHealth(vehicleid);
				local health = cmd[1].tointeger();
				setVehicleEngineHealth(vehicleid, health);
				sendPlayerMessage(playerid, "Vehicle health set from " + oldhealth + " to " + health);
			}
		}
	}
	
	return 0;
}
addEvent("playerCommand", onPlayerCommand);

function onPlayerDeath(playerid, killerid)
{
	if(killerid != INVALID_PLAYER_ID)
		sendMessageToAll("[FF0000FF]" + getPlayerName(playerid) + " [FFFFFFFF](" + playerid + ") was killed by [FFFF0000]" + getPlayerName(killerid) + " [FFFFFFFF](" + killerid + ").", White, true);
	else
		sendMessageToAll(getPlayerName(playerid) + " died");

	return 1;
}
addEvent("playerDeath", onPlayerDeath);